#version 330
#extension GL_EXT_gpu_shader4 : enable
//SHADE A DAY 2_4_2015Mod01.fsh by cabbibo
//https://www.shadertoy.com/view/Xls3zS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177 //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// ALL TAKEN FROM IQs AMAZING SITE / TUTORIALS / SHADERS:
// https://iquilezles.org/www/index.htm
// https://www.shadertoy.com/user/iq

const float MAX_TRACE_DISTANCE = 10.0;           // max trace distance
const float INTERSECTION_PRECISION = 0.001;        // precision of the intersection
const int NUM_OF_TRACE_STEPS = 140;
	
vec4 spherePos[10];

vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture( sam, p.yz );
	vec4 y = texture( sam, p.zx );
	vec4 z = texture( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}


float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float sdPlane( vec3 p )
{
    
    float f = sin( p.z * 5. ) * sin( p.x * 5. );
    //f = 5. * smoothstep( abs(f) , 0.4 , 0.8 );
	return p.y - (abs( f) * .3)/ max( 1. , pow( length( p ), 1.));

}


float sdSphere( vec3 p, float s , float offset)
{
    //p.x += 0.1*sin( 60.0*p.y * p.x * p.z * abs(sin(offset *iTime)) + iTime );
    //p.y += 0.1*sin( 60.0*p.y * p.x * p.z * abs(sin(offset *iTime * .4)) + iTime );
  //  p.y += 0.1*sin( 10.0*p.z + iTime *10.);
  //  p.z += 0.1*sin( 30.0*p.x + iTime *3.);
    /*p.x += 0.5*sin( 3.0*p.y + iTime );
    p.y += 0.5*sin( 3.0*p.z + iTime );
    p.z += 0.5*sin( 3.0*p.x + iTime );
    p.x += 0.5*sin( 3.0*p.y + iTime );
    p.y += 0.5*sin( 3.0*p.z + iTime );
    p.z += 0.5*sin( 3.0*p.x + iTime );
    p.x += 0.5*sin( 3.0*p.y + iTime );
    p.y += 0.5*sin( 3.0*p.z + iTime );
    p.z += 0.5*sin( 3.0*p.x + iTime );*/

    float d1 = length(p) - .1*smoothstep(0.0,1.0,iTime);;
    d1 *= .8;	
    
   // vec3 nP = vec3( x , y , z );
    return d1 -s;
}

float sdCone( in vec3 p, in vec3 c )
{
    vec2 q = vec2( length(p.xz), p.y );

    float d1 = -p.y-c.z;
    float d2 = max( dot(q,c.xy), p.y);
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);

}

//----
// Camera Stuffs
//----
mat3 calcLookAtMatrix( in vec3 ro, in vec3 ta, in float roll )
{
    vec3 ww = normalize( ta - ro );
    vec3 uu = normalize( cross(ww,vec3(sin(roll),cos(roll),0.0) ) );
    vec3 vv = normalize( cross(uu,ww));
    return mat3( uu, vv, ww );
}

void doCamera( out vec3 camPos, out vec3 camTar, in float time, in float mouseX )
{
    float an = 0.3 + 10.0*mouseX;
	camPos = vec3(3.5*sin(an),1.0,3.5*cos(an));
    camTar = vec3(0.0,0.0,0.0);
}




// checks to see which intersection is closer
// and makes the y of the vec2 be the proper id
vec2 opU( vec2 d1, vec2 d2 ){
    
	return (d1.x<d2.x) ? d1 : d2;
    
}

//--------------------------------
// Modelling 
//--------------------------------
vec2 map( vec3 pos ){  
    
   	vec2 res = vec2( sdPlane( pos - vec3( 0. , -1. , 0. )), 0.0 );
   
    for( int i = 0; i < 10; i++ ){
   		
        vec2 res2 = vec2( sdSphere( (pos - spherePos[i].xyz) , spherePos[i].w  , float( i )) , float(i) + 1.);
        //vec2 res2 = vec2( udRoundBox( (pos - spherePos[i].xyz) , vec3( spherePos[i].w  ) ,spherePos[i].w * .2 ) , float(i) + 1.);
   		res = opU( res ,  res2 );
        
   	}
    
   	return res;
    
}



vec2 calcIntersection( in vec3 ro, in vec3 rd ){

    
    float h =  INTERSECTION_PRECISION*2.0;
    float t = 0.0;
	float res = -1.0;
    float id = -1.;
    
    for( int i=0; i< NUM_OF_TRACE_STEPS ; i++ ){
        
        if( h < INTERSECTION_PRECISION || t > MAX_TRACE_DISTANCE ) break;
	   	vec2 m = map( ro+rd*t );
        h = m.x;
        t += h;
        id = m.y;
        
    }

    if( t < MAX_TRACE_DISTANCE ) res = t;
    if( t > MAX_TRACE_DISTANCE ) id =-1.0;
    
    return vec2( res , id );
    
}

// Calculates the normal by taking a very small distance,
// remapping the function, and getting normal for that
vec3 calcNormal( in vec3 pos ){
    
	vec3 eps = vec3( 0.001, 0.0, 0.0 );
	vec3 nor = vec3(
	    map(pos+eps.xyy).x - map(pos-eps.xyy).x,
	    map(pos+eps.yxy).x - map(pos-eps.yxy).x,
	    map(pos+eps.yyx).x - map(pos-eps.yyx).x );
	return normalize(nor);
}


float softshadow( in vec3 ro, in vec3 rd, in float mint, in float tmax )
{
	float res = 1.0;
    float t = mint;
    for( int i=0; i<50; i++ )
    {
		float h = map( ro + rd*t ).x;
        res = min( res, 20.*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.001 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );

}


float calcAO( in vec3 pos, in vec3 nor )
{
	float occ = 0.0;
    float sca = 1.0;
    for( int i=0; i<5; i++ )
    {
        float hr = 0.01 + 0.612*float(i)/4.0;
        vec3 aopos =  nor * hr + pos;
        float dd = map( aopos ).x;
        occ += -(dd-hr)*sca;
        sca *= 0.5;
    }
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 );    
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
     for( int i =0; i < 10; i++ ){
        
        float x = 1. * cos(iTime *.13 * (float( i )+2.));
        float y = 1. * sin(iTime * .075 * (float( i )+4.));
        float z = 1. * sin(iTime * .1 * (float( i )+3.3));
        float r = .1 * ( sin( iTime * .1  *( float( i) +1.))+2.);
    	spherePos[i] = vec4( x ,  y+1. ,  z , r  );
   }
    
    vec2 p = (-iResolution.xy + 2.0*gl_FragCoord.xy)/iResolution.y;
    vec2 m = iMouse.xy/iResolution.xy;

    //-----------------------------------------------------
    // camera
    //-----------------------------------------------------
    
    // camera movement
    vec3 ro, ta;
    doCamera( ro, ta, iTime, m.x );

    // camera matrix
    mat3 camMat = calcLookAtMatrix( ro, ta, 0.0 );  // 0.0 is the camera roll
    
	// create view ray
	vec3 rd = normalize( camMat * vec3(p.xy,2.0) ); // 2.0 is the lens length
    
    vec2 res = calcIntersection( ro , rd  );
     
    vec3 col = vec3( 0. , 0. , 0. ); 
   
    // If we have hit something lets get real!
    if( res.y > -.5 ){

    	vec3 pos = ro + rd * res.x;
    	vec3 nor = calcNormal( pos );
        
        vec3 pat = texCube( iChannel0, 0.5*pos, nor, 10.0 ).xyz;
        col = pat * normalize(vec3(1. ) + vec3( abs(sin( res.y )) , .3  , abs(cos(res.y)) ));
        if( res.y < .5 ){ col = vec3(1.) * pat; }
        
        float AO = calcAO( pos , nor );
        
        vec3 light1 =  normalize(vec3( 0. , 1. , 1. ));
        vec3 color1 = vec3( .1 , .05 , .02 );
        color1 *=10.;
        float shadow1 = softshadow( pos , light1 ,  0.1 , 20. );
        
        vec3 light2 =  normalize(vec3( 1. , 1. , -1. ));
        vec3 color2 = vec3( .02, .05 , 0.1 );
        color2 *= 8.;
        float shadow2 = softshadow( pos , light2 ,  0.1 , 20. );
        
        vec3 light3 =  normalize(vec3( 0. , 1. , 0. ));
        vec3 color3 = vec3( .02, .1 , .05 );
        color3 *= 8.;
        float shadow3 = softshadow( pos , light3 ,  0.1 , 20. );
      
        // vec3 = calcColor( ro , rd );
    
        color1 *= max( 0. , dot( light1 , nor ) );
        color1 *= shadow1;
        
        color2 *= max( 0. , dot( light2 , nor ) );
        color2 *= shadow2;
        
        color3 *= max( 0. , dot( light3 , nor ) );
        color3 *= shadow3;
        

        //col = vec3( AO );
        col *= color1 + color2 + color3; //* ((nor * .5 ) +.5);

        col *= AO;// * .4 * ( nor * .5 + .5 );
        
        if( res.y < .5 ){
            
            float f = sin( pos.z * 5. ) * sin( pos.x * 5. );
            //col *= 5. * smoothstep( abs(f) , 0.4 , 0.8 );
            col *= abs( f );
            col /= pow( length( pos ), 4.);
        }
    }
    // apply gamma correction
    col = pow( col, vec3(0.4545) );

    gl_FragColor = vec4( col , 1. );
    
}
